<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Track extends Model 
{

    protected $table = 'tracks';
    public $timestamps = true;

    public function artists()
    {
        return $this->hasManyThrough('TrackArtistMapping');
    }

    public function languages()
    {
        return $this->hasManyThrough('Language', 'track_language_mappings');
    }

    public function genres()
    {
        return $this->hasManyThrough('Genre', 'track_genre_mappings');
    }

    public function album()
    {
        return $this->hasOne('Album');
    }

    public function reviews()
    {
        return $this->hasMany('Review');
    }

}